document.addEventListener('DOMContentLoaded', function() {
    console.log('Test Question 2 page loaded successfully');
    
    // Create audio context for success sound
    let audioContext = null;
    let isAnswered = false; // Prevent multiple clicks
    
    function playSuccessSound() {
        try {
            // Create audio context (browser-compatible)
            audioContext = new (window.AudioContext || window.webkitAudioContext)();
            
            // Create oscillator for a pleasant "ding" sound
            const oscillator = audioContext.createOscillator();
            const gainNode = audioContext.createGain();
            
            oscillator.connect(gainNode);
            gainNode.connect(audioContext.destination);
            
            // Configure the sound (two-tone success sound)
            oscillator.frequency.value = 800; // First tone
            oscillator.type = 'sine';
            
            gainNode.gain.setValueAtTime(0.3, audioContext.currentTime);
            gainNode.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.5);
            
            oscillator.start(audioContext.currentTime);
            oscillator.stop(audioContext.currentTime + 0.5);
            
            // Add second tone
            const oscillator2 = audioContext.createOscillator();
            const gainNode2 = audioContext.createGain();
            
            oscillator2.connect(gainNode2);
            gainNode2.connect(audioContext.destination);
            
            oscillator2.frequency.value = 1000; // Higher tone
            oscillator2.type = 'sine';
            
            gainNode2.gain.setValueAtTime(0, audioContext.currentTime + 0.1);
            gainNode2.gain.setValueAtTime(0.3, audioContext.currentTime + 0.15);
            gainNode2.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.6);
            
            oscillator2.start(audioContext.currentTime + 0.1);
            oscillator2.stop(audioContext.currentTime + 0.6);
            
            console.log('Success sound played');
        } catch (error) {
            console.error('Error playing sound:', error);
        }
    }
    
    function handleCorrectAnswer(element) {
        if (isAnswered) return;
        isAnswered = true;
        
        console.log('Correct answer selected!');
        element.classList.add('answer-correct');
        playSuccessSound();
        
        // Navigate to Question 3 after animation
        setTimeout(function() {
            window.location.href = 'test3.html';
        }, 1000);
    }
    
    function handleWrongAnswer(element) {
        if (isAnswered) return;
        
        console.log('Wrong answer selected - no effect');
        // No visual effects for wrong answers
    }
    
    // Click handlers for answer options
    const answerA = document.querySelector('.answer-a');
    const answerB = document.querySelector('.answer-b');
    const answerC = document.querySelector('.answer-c');
    const answerD = document.querySelector('.answer-d');
    
    if (answerA) {
        answerA.addEventListener('click', function() {
            handleWrongAnswer(answerA);
        });
    }
    
    if (answerB) {
        answerB.addEventListener('click', function() {
            handleWrongAnswer(answerB);
        });
    }
    
    if (answerC) {
        answerC.addEventListener('click', function() {
            handleCorrectAnswer(answerC); // C is correct
        });
    }
    
    if (answerD) {
        answerD.addEventListener('click', function() {
            handleWrongAnswer(answerD);
        });
    }
});
